try:
    import bpy

    bpy.types.Scene.mc_auth_key = bpy.props.StringProperty(
        name="Auth Key",
        default="",
        description="授权Key",
    )
    bpy.types.Scene.mc_auth_secret = bpy.props.StringProperty(
        name="Auth Secret",
        default="",
        description="授权Secret",
    )

    bpy.types.Scene.mc_rhythm_points = bpy.props.StringProperty(
        name="Rhythm",
        default="",
        description="音乐节奏时间点",
    )

    bpy.types.Scene.mc_jump_factor = bpy.props.FloatProperty(
        # name="Bounce Factor",
        name="弹跳系数",
        default=0.5,  # 默认值
        min=0.1,  # 最小值
        max=1,  # 最大值
        step=0.1,
        options={'HIDDEN'},
        precision=1,  # 精度，小数点后几位
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="弹跳系数，影响小球跳跃高度",
        # unit="ACCELERATION"
    )
    bpy.types.Scene.mc_speed_factor = bpy.props.FloatProperty(
        name="Speed Factor",
        default=0.1,  # 默认值
        min=0.1,  # 最小值
        max=1,  # 最大值
        step=0.1,
        options={'HIDDEN'},
        precision=1,  # 精度，小数点后几位
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="速度系数，影响小球运动速度",
    )
    bpy.types.Scene.mc_bpm = bpy.props.IntProperty(
        name="BPM",
        default=120,  # 默认值
        min=60,  # 最小值
        max=1200,  # 最大值
        options={'HIDDEN'},
        step=1,
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="拍速，影响运动方式",
    )
    bpy.types.Scene.mc_background = bpy.props.PointerProperty(
        # name="Ball",
        name="背景墙",
        type=bpy.types.Object,
        description="选中背景墙",
    )
    bpy.types.Scene.mc_ball = bpy.props.PointerProperty(
        # name="Ball",
        name="小球",
        type=bpy.types.Object,
        description="选中小球",
    )
    bpy.types.Scene.mc_camera = bpy.props.PointerProperty(
        # name="Ball",
        name="相机",
        type=bpy.types.Object,
        description="选中相机",
    )
    bpy.types.Scene.mc_pad = bpy.props.PointerProperty(
        name="跳板",
        type=bpy.types.Object,
        description="选中小球跳板",
    )

    bpy.types.Scene.mc_support = bpy.props.PointerProperty(
        name="跳板支撑",
        type=bpy.types.Object,
        description="选中跳板支撑",
    )
    bpy.types.Scene.mc_track_material = bpy.props.PointerProperty(
        name="轨道材质",
        type=bpy.types.Material,
        description="选中材质",
    )
    bpy.types.Scene.mc_track_support_material = bpy.props.PointerProperty(
        name="轨道支撑材质",
        type=bpy.types.Material,
        description="选中轨道支撑材质",
    )

    bpy.types.Scene.mc_pad_pre_luminous = bpy.props.IntProperty(
        # name="Bounce Factor",
        name="跳板发光值(碰撞前)",
        default=0,  # 默认值
        min=0,  # 最小值
        max=10,  # 最大值
        options={'HIDDEN'},
        step=1,
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="跳板碰撞前发光值",
    )
    bpy.types.Scene.mc_pad_post_luminous = bpy.props.IntProperty(
        # name="Bounce Factor",
        name="跳板发光值(碰撞后)",
        default=0,  # 默认值
        min=0,  # 最小值
        max=10,  # 最大值
        step=1,
        options={'HIDDEN'},
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="跳板碰撞后发光值",
    )
    bpy.types.Scene.mc_update_layout = bpy.props.BoolProperty(
        name="更新小球关键位置",
        options={'HIDDEN'},
        default=True,  # 默认值
        description="更新小球关键位置",
    )
    bpy.types.Scene.mc_update_camera_animation = bpy.props.BoolProperty(
        name="更新相机动画",
        options={'HIDDEN'},
        default=True,  # 默认值
        description="更新相机动画，不勾选则相机动画保持不变",
    )
    bpy.types.Scene.mc_expire_tips = bpy.props.StringProperty(
        name="授权时间",
        options={'HIDDEN'},
        description="授权码到期时间",
        update=lambda self, context: None
    )
    ####### camera

    bpy.types.Scene.mc_camera_remain_distance = bpy.props.IntProperty(
        name="慢跟拍",
        default=4,  # 默认值
        min=0,  # 最小值
        max=10,  # 最大值
        options={'HIDDEN'},
        step=1,
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="相机延迟移动",
    )
    bpy.types.Scene.mc_camera_offset_y = bpy.props.IntProperty(
        name="拍摄距离",
        default=35,  # 默认值
        min=10,  # 最小值
        max=100,  # 最大值
        options={'HIDDEN'},
        step=1,
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="相机距离物体远近",
    )
    bpy.types.Scene.mc_camera_offset_z = bpy.props.IntProperty(
        name="拍摄高度",
        default=2,  # 默认值
        min=0,  # 最小值
        max=10,  # 最大值
        options={'HIDDEN'},
        step=1,
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="相机距离物体高度",
    )
    bpy.types.Scene.mc_camera_rotation_x = bpy.props.IntProperty(
        name="拍摄角度",
        default=-10,  # 默认值
        min=-60,  # 最小值
        max=60,  # 最大值
        options={'HIDDEN'},
        step=1,
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="相机拍摄角度",
    )
    ###############
    bpy.types.Scene.mc_layout_seed = bpy.props.IntProperty(
        name="布局编号",
        default=99,  # 默认值
        min=0,  # 最小值
        max=999999,  # 最大值
        options={'HIDDEN'},
        step=1,
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="一个编号代表一种布局，编号不变布局不变",
    )
    bpy.types.Scene.mc_beat_source = bpy.props.EnumProperty(
        name="鼓点数据源",
        default='音轨标记',  # 默认值
        items=[
            ('音轨标记', '音轨标记', '音轨标记'),
            ('自定义', '自定义', '自定义'),
        ],
        options={'HIDDEN'},
        description="鼓点数据源",
    )

except ModuleNotFoundError:
    pass
