try:
    import bpy

    bpy.types.Scene.bc_midi = bpy.props.StringProperty(
        name="MIDI文件",
        description=".mid 文件",
        subtype='FILE_PATH',
        maxlen=1024,
        update=lambda self, context: None
    )
    bpy.types.Scene.bc_score_data = bpy.props.StringProperty(
        name="_score_data",
        maxlen=1024 * 1024,
        update=lambda self, context: None
    )
    bpy.types.Scene.bc_obj_svg_score = bpy.props.PointerProperty(
        name="乐谱",
        type=bpy.types.Object,
        description="选中乐谱",
    )
    bpy.types.Scene.bc_obj_bounce = bpy.props.PointerProperty(
        name="弹跳物体",
        type=bpy.types.Object,
        description="选中弹跳物体作为模板",
    )
    bpy.types.Scene.bc_camera = bpy.props.PointerProperty(
        name="摄像机",
        type=bpy.types.Object,
        description="选中摄像机",
    )
    bpy.types.Scene.bc_import_svg_as_gspencil = bpy.props.BoolProperty(
        name="导入乐谱为蜡笔",
        description="默认导入为曲线",
        default=False
    )
    bpy.types.Scene.bc_bounce_factor = bpy.props.FloatProperty(
        name="弹跳曲线高度系数",
        default=0.5,  # 默认值
        min=0.01,  # 最小值
        max=1,  # 最大值
        step=0.01,
        precision=2,  # 精度，小数点后几位
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        # description="弹跳系数，影响小球跳跃高度",
    )
    bpy.types.Scene.bc_animation_delay = bpy.props.IntProperty(
        name="动画延迟",
        default=0,  # 默认值
        min=0,  # 最小值
        max=1200,  # 最大值
        step=1,
        subtype='FACTOR',  # 可以是'FACTOR', 'PERCENTAGE', 'TIME', 'DISTANCE', 'ANGLE'
        description="延迟帧数",
    )


except ModuleNotFoundError:
    pass
