import unittest

import bcutils


class TestBounceCurve(unittest.TestCase):
    def test_cal_scale_and_offset(self):
        scale, offset = bcutils.cal_scale_and_offset([[(0, 0), (10, 0)], [(0, 1), (10, 1)]],
                                                     [[(0, 0), (1, 0)], [(0, -0.2), (1, -0.2)]])
        self.assertEqual(scale, (0.1, -0.2))
        self.assertEqual(offset, (0, 0))
        scale, offset = bcutils.cal_scale_and_offset([[(0, 0), (10, 0)], [(0, 1), (10, 1)]],
                                                     [[(-1, 0), (1, 0)], [(-1, -0.2), (1, -0.2)]])
        self.assertEqual(scale, (0.2, -0.2))
        self.assertEqual(offset, (-1, 0))
        scale, offset = bcutils.cal_scale_and_offset([[(0, 0), (10, 0)], [(0, 1), (10, 1)]],
                                                     [[(-1, -0.1), (1, -0.1)], [(-1, -0.2), (1, -0.2)]])
        self.assertEqual(scale, (0.2, -0.1))
        self.assertEqual(offset, (-1, -0.1))

        # scale, offset = bcutils.cal_scale_and_offset([[[336.598, 634.198], [28719.4, 634.198]], [[336.598, 658.998], [28719.4, 658.998]], [[336.598, 683.798], [28719.4, 683.798]], [[336.598, 708.598], [28719.4, 708.598]], [[336.598, 733.398], [28719.4, 733.398]]],
        #                                              [[(-37.54808044433594, 8.801670503544301e-09, 0.20135867595672607), (-29.204063415527344, 8.801670503544301e-09, 0.20135867595672607), (-20.860044479370117, 8.801670503544301e-09, 0.20135867595672607), (-12.51602554321289, 8.801670503544301e-09, 0.20135867595672607), (-4.172004699707031, 8.801670503544301e-09, 0.20135867595672607), (4.172008514404297, 8.801670503544301e-09, 0.20135867595672607), (12.51602554321289, 8.801670503544301e-09, 0.20135867595672607), (20.86004638671875, 8.801670503544301e-09, 0.20135867595672607), (29.204059600830078, 8.801670503544301e-09, 0.20135867595672607), (37.5480842590332, 8.801670503544301e-09, 0.20135867595672607)],
        #                                               [(-37.54808044433594, 5.933472380093008e-09, 0.1357419490814209), (-29.204063415527344, 5.933472380093008e-09, 0.1357419490814209), (-20.860044479370117, 5.933472380093008e-09, 0.1357419490814209), (-12.51602554321289, 5.933472380093008e-09, 0.1357419490814209), (-4.172004699707031, 5.933472380093008e-09, 0.1357419490814209), (4.172008514404297, 5.933472380093008e-09, 0.1357419490814209), (12.51602554321289, 5.933472380093008e-09, 0.1357419490814209), (20.86004638671875, 5.933472380093008e-09, 0.1357419490814209), (29.204059600830078, 5.933472380093008e-09, 0.1357419490814209), (37.5480842590332, 5.933472380093008e-09, 0.1357419490814209)],
        #                                               [(-37.54808044433594, 3.0652742566417146e-09, 0.07012534141540527), (-29.204063415527344, 3.0652742566417146e-09, 0.07012534141540527), (-20.860044479370117, 3.0652742566417146e-09, 0.07012534141540527), (-12.51602554321289, 3.0652742566417146e-09, 0.07012534141540527), (-4.172004699707031, 3.0652742566417146e-09, 0.07012534141540527), (4.172008514404297, 3.0652742566417146e-09, 0.07012534141540527), (12.51602554321289, 3.0652742566417146e-09, 0.07012534141540527), (20.86004638671875, 3.0652742566417146e-09, 0.07012534141540527), (29.204059600830078, 3.0652742566417146e-09, 0.07012534141540527), (37.5480842590332, 3.0652742566417146e-09, 0.07012534141540527)],
        #                                               [(-37.54808044433594, 1.97083238617779e-10, 0.0045087337493896484), (-29.204063415527344, 1.97083238617779e-10, 0.0045087337493896484), (-20.860044479370117, 1.97083238617779e-10, 0.0045087337493896484), (-12.51602554321289, 1.97083238617779e-10, 0.0045087337493896484), (-4.172004699707031, 1.97083238617779e-10, 0.0045087337493896484), (4.172008514404297, 1.97083238617779e-10, 0.0045087337493896484), (12.51602554321289, 1.97083238617779e-10, 0.0045087337493896484), (20.86004638671875, 1.97083238617779e-10, 0.0045087337493896484), (29.204059600830078, 1.97083238617779e-10, 0.0045087337493896484), (37.5480842590332, 1.97083238617779e-10, 0.0045087337493896484)],
        #                                               [(-37.54808044433594, -2.6711148848335142e-09, -0.06110799312591553), (-29.204063415527344, -2.6711148848335142e-09, -0.06110799312591553), (-20.860044479370117, -2.6711148848335142e-09, -0.06110799312591553), (-12.51602554321289, -2.6711077794061566e-09, -0.06110787391662598), (-4.172004699707031, -2.6711148848335142e-09, -0.06110799312591553), (4.172008514404297, -2.6711148848335142e-09, -0.06110799312591553), (12.51602554321289, -2.6711077794061566e-09, -0.06110787391662598), (20.86004638671875, -2.6711148848335142e-09, -0.06110799312591553), (29.204059600830078, -2.6711148848335142e-09, -0.06110799312591553), (37.5480842590332, -2.6711148848335142e-09, -0.06110799312591553)]])
        # self.assertEqual(scale, (0.002645833371327085, -0.002645833371327085))
        # self.assertEqual(offset, (-1, -0.1))