import importlib

try:
    import bpy
    from .musicball import scene
    from . import utils
    from .musicball import musicball
    from .bouncecurve import bouncecurve
    from .bouncecurve import scene as bcscene
except ModuleNotFoundError as e:
    from musicball import scene
    from bouncecurve import scene as bcscene
    import utils
    from musicball import musicball
    from bouncecurve import bouncecurve

bl_info = {
    "name": "Mercury",
    "blender": (2, 80, 0),
    "category": "Object",
}


def reloads(packages):
    for p in packages:
        try:
            importlib.reload(p)
        except:
            pass


def registers(cls):
    for c in cls:
        bpy.utils.register_class(c)


def unregisters(cls):
    for c in cls:
        bpy.utils.unregister_class(c)


packages = [
    scene,
    utils,
    bcscene
]
widgets = [
    musicball.UpdateAnimationOperator,
    musicball.RandomLayoutSeedOperator,
    musicball.MusicBallPanel,
    bouncecurve.BounceCurvePanel,
    bouncecurve.GenerateScoreOperator,
    bouncecurve.GenerateBounceCurveOperator,
    bouncecurve.RectifyOffsetOperator,
    bouncecurve.GenerateCameraOperator,
]


class BounceItem(bpy.types.PropertyGroup):
    obj: bpy.props.PointerProperty(type=bpy.types.Object, name="弹跳对象")


# 注册和注销函数
def register():
    reloads(packages)
    registers(widgets)
    bpy.utils.register_class(BounceItem)
    bpy.types.Scene.bc_real_obj_bounce = bpy.props.CollectionProperty(
        type=BounceItem,
        name="弹跳物体",
    )


def unregister():
    unregisters(widgets)
    del bpy.types.Scene.bc_real_obj_bounce


if __name__ == "__main__":
    register()
